// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Mobile App Collection Request.
 */
public class ManagedMobileAppCollectionRequest extends BaseCollectionRequest<ManagedMobileAppCollectionResponse, IManagedMobileAppCollectionPage> implements IManagedMobileAppCollectionRequest {

    /**
     * The request builder for this collection of ManagedMobileApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedMobileAppCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedMobileAppCollectionResponse.class, IManagedMobileAppCollectionPage.class);
    }

    public void get(final ICallback<IManagedMobileAppCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IManagedMobileAppCollectionPage get() throws ClientException {
        final ManagedMobileAppCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ManagedMobileApp newManagedMobileApp, final ICallback<ManagedMobileApp> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ManagedMobileAppRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newManagedMobileApp, callback);
    }

    public ManagedMobileApp post(final ManagedMobileApp newManagedMobileApp) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ManagedMobileAppRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newManagedMobileApp);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IManagedMobileAppCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ManagedMobileAppCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IManagedMobileAppCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ManagedMobileAppCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IManagedMobileAppCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedMobileAppCollectionRequest)this;
    }

    public IManagedMobileAppCollectionPage buildFromResponse(final ManagedMobileAppCollectionResponse response) {
        final IManagedMobileAppCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ManagedMobileAppCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ManagedMobileAppCollectionPage page = new ManagedMobileAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
