// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IItemAnalyticsRequest;
import com.microsoft.graph.requests.extensions.ItemAnalyticsRequest;
import com.microsoft.graph.models.extensions.ItemAnalytics;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Analytics Request.
 */
public class ItemAnalyticsRequest extends BaseRequest implements IItemAnalyticsRequest {
	
    /**
     * The request for the ItemAnalytics
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemAnalyticsRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemAnalytics.class);
    }

    /**
     * Gets the ItemAnalytics from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<ItemAnalytics> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ItemAnalytics from the service
     *
     * @return the ItemAnalytics from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAnalytics get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<ItemAnalytics> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ItemAnalytics with a source
     *
     * @param sourceItemAnalytics the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ItemAnalytics sourceItemAnalytics, final ICallback<ItemAnalytics> callback) {
        send(HttpMethod.PATCH, callback, sourceItemAnalytics);
    }

    /**
     * Patches this ItemAnalytics with a source
     *
     * @param sourceItemAnalytics the source object with updates
     * @return the updated ItemAnalytics
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAnalytics patch(final ItemAnalytics sourceItemAnalytics) throws ClientException {
        return send(HttpMethod.PATCH, sourceItemAnalytics);
    }

    /**
     * Creates a ItemAnalytics with a new object
     *
     * @param newItemAnalytics the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ItemAnalytics newItemAnalytics, final ICallback<ItemAnalytics> callback) {
        send(HttpMethod.POST, callback, newItemAnalytics);
    }

    /**
     * Creates a ItemAnalytics with a new object
     *
     * @param newItemAnalytics the new object to create
     * @return the created ItemAnalytics
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ItemAnalytics post(final ItemAnalytics newItemAnalytics) throws ClientException {
        return send(HttpMethod.POST, newItemAnalytics);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IItemAnalyticsRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (ItemAnalyticsRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IItemAnalyticsRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (ItemAnalyticsRequest)this;
     }

}

