// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.SchemaExtension;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Schema Extension Request.
 */
public interface ISchemaExtensionRequest extends IHttpRequest {

    /**
     * Gets the SchemaExtension from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<SchemaExtension> callback);

    /**
     * Gets the SchemaExtension from the service
     *
     * @return the SchemaExtension from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SchemaExtension get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<SchemaExtension> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SchemaExtension with a source
     *
     * @param sourceSchemaExtension the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final SchemaExtension sourceSchemaExtension, final ICallback<SchemaExtension> callback);

    /**
     * Patches this SchemaExtension with a source
     *
     * @param sourceSchemaExtension the source object with updates
     * @return the updated SchemaExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SchemaExtension patch(final SchemaExtension sourceSchemaExtension) throws ClientException;

    /**
     * Posts a SchemaExtension with a new object
     *
     * @param newSchemaExtension the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final SchemaExtension newSchemaExtension, final ICallback<SchemaExtension> callback);

    /**
     * Posts a SchemaExtension with a new object
     *
     * @param newSchemaExtension the new object to create
     * @return the created SchemaExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SchemaExtension post(final SchemaExtension newSchemaExtension) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISchemaExtensionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISchemaExtensionRequest expand(final String value);

}

