// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IItemAnalyticsRequest;
import com.microsoft.graph.requests.extensions.IItemActivityStatCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IItemActivityStatRequestBuilder;
import com.microsoft.graph.requests.extensions.IItemActivityStatWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IItemActivityStatWithReferenceRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Item Analytics Request Builder.
 */
public interface IItemAnalyticsRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IItemAnalyticsRequest instance
     */
    IItemAnalyticsRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IItemAnalyticsRequest instance
     */
    IItemAnalyticsRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IItemActivityStatCollectionRequestBuilder itemActivityStats();

    IItemActivityStatRequestBuilder itemActivityStats(final String id);

    /**
     * Gets the request builder for ItemActivityStat
     *
     * @return the IItemActivityStatWithReferenceRequestBuilder instance
     */
    IItemActivityStatWithReferenceRequestBuilder allTime();

    /**
     * Gets the request builder for ItemActivityStat
     *
     * @return the IItemActivityStatWithReferenceRequestBuilder instance
     */
    IItemActivityStatWithReferenceRequestBuilder lastSevenDays();

}
