// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Event;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Event Request.
 */
public interface IEventRequest extends IHttpRequest {

    /**
     * Gets the Event from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Event> callback);

    /**
     * Gets the Event from the service
     *
     * @return the Event from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Event get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Event> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Event with a source
     *
     * @param sourceEvent the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Event sourceEvent, final ICallback<Event> callback);

    /**
     * Patches this Event with a source
     *
     * @param sourceEvent the source object with updates
     * @return the updated Event
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Event patch(final Event sourceEvent) throws ClientException;

    /**
     * Posts a Event with a new object
     *
     * @param newEvent the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Event newEvent, final ICallback<Event> callback);

    /**
     * Posts a Event with a new object
     *
     * @param newEvent the new object to create
     * @return the created Event
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Event post(final Event newEvent) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEventRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEventRequest expand(final String value);

}

