// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEducationUserRequest;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserWithReferenceRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Education User Request Builder.
 */
public interface IEducationUserRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IEducationUserRequest instance
     */
    IEducationUserRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IEducationUserRequest instance
     */
    IEducationUserRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IEducationSchoolCollectionWithReferencesRequestBuilder schools();

    IEducationSchoolWithReferenceRequestBuilder schools(final String id);

    IEducationClassCollectionWithReferencesRequestBuilder classes();

    IEducationClassWithReferenceRequestBuilder classes(final String id);

    /**
     * Gets the request builder for User
     *
     * @return the IUserWithReferenceRequestBuilder instance
     */
    IUserWithReferenceRequestBuilder user();

}
