// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyRequest;
import com.microsoft.graph.requests.extensions.IDeviceComplianceScheduledActionForRuleCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceScheduledActionForRuleRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceUserStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceUserStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceDeviceOverviewRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceUserOverviewRequestBuilder;
import com.microsoft.graph.requests.extensions.ISettingStateDeviceSummaryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISettingStateDeviceSummaryRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignmentRequestBuilder;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyAssignCollectionRequestBuilder;
import com.microsoft.graph.models.extensions.DeviceComplianceScheduledActionForRule;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyScheduleActionsForRulesRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Compliance Policy Request Builder.
 */
public interface IDeviceCompliancePolicyRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IDeviceCompliancePolicyRequest instance
     */
    IDeviceCompliancePolicyRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IDeviceCompliancePolicyRequest instance
     */
    IDeviceCompliancePolicyRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IDeviceComplianceScheduledActionForRuleCollectionRequestBuilder scheduledActionsForRule();

    IDeviceComplianceScheduledActionForRuleRequestBuilder scheduledActionsForRule(final String id);

    IDeviceComplianceDeviceStatusCollectionRequestBuilder deviceStatuses();

    IDeviceComplianceDeviceStatusRequestBuilder deviceStatuses(final String id);

    IDeviceComplianceUserStatusCollectionRequestBuilder userStatuses();

    IDeviceComplianceUserStatusRequestBuilder userStatuses(final String id);

    /**
     * Gets the request builder for DeviceComplianceDeviceOverview
     *
     * @return the IDeviceComplianceDeviceOverviewRequestBuilder instance
     */
    IDeviceComplianceDeviceOverviewRequestBuilder deviceStatusOverview();

    /**
     * Gets the request builder for DeviceComplianceUserOverview
     *
     * @return the IDeviceComplianceUserOverviewRequestBuilder instance
     */
    IDeviceComplianceUserOverviewRequestBuilder userStatusOverview();

    ISettingStateDeviceSummaryCollectionRequestBuilder deviceSettingStateSummaries();

    ISettingStateDeviceSummaryRequestBuilder deviceSettingStateSummaries(final String id);

    IDeviceCompliancePolicyAssignmentCollectionRequestBuilder assignments();

    IDeviceCompliancePolicyAssignmentRequestBuilder assignments(final String id);

    IDeviceCompliancePolicyAssignCollectionRequestBuilder assign(final java.util.List<DeviceCompliancePolicyAssignment> assignments);
    IDeviceCompliancePolicyScheduleActionsForRulesRequestBuilder scheduleActionsForRules(final java.util.List<DeviceComplianceScheduledActionForRule> deviceComplianceScheduledActionForRules);

}
