// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Install State Summary Collection Request.
 */
public class UserInstallStateSummaryCollectionRequest extends BaseCollectionRequest<UserInstallStateSummaryCollectionResponse, IUserInstallStateSummaryCollectionPage> implements IUserInstallStateSummaryCollectionRequest {

    /**
     * The request builder for this collection of UserInstallStateSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserInstallStateSummaryCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserInstallStateSummaryCollectionResponse.class, IUserInstallStateSummaryCollectionPage.class);
    }

    public void get(final ICallback<IUserInstallStateSummaryCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IUserInstallStateSummaryCollectionPage get() throws ClientException {
        final UserInstallStateSummaryCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final UserInstallStateSummary newUserInstallStateSummary, final ICallback<UserInstallStateSummary> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new UserInstallStateSummaryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newUserInstallStateSummary, callback);
    }

    public UserInstallStateSummary post(final UserInstallStateSummary newUserInstallStateSummary) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new UserInstallStateSummaryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newUserInstallStateSummary);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IUserInstallStateSummaryCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (UserInstallStateSummaryCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IUserInstallStateSummaryCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (UserInstallStateSummaryCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IUserInstallStateSummaryCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (UserInstallStateSummaryCollectionRequest)this;
    }

    public IUserInstallStateSummaryCollectionPage buildFromResponse(final UserInstallStateSummaryCollectionResponse response) {
        final IUserInstallStateSummaryCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new UserInstallStateSummaryCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final UserInstallStateSummaryCollectionPage page = new UserInstallStateSummaryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
