// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IUserActivityRequest;
import com.microsoft.graph.requests.extensions.UserActivityRequest;
import com.microsoft.graph.models.extensions.UserActivity;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Activity Request.
 */
public class UserActivityRequest extends BaseRequest implements IUserActivityRequest {
	
    /**
     * The request for the UserActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserActivityRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserActivity.class);
    }

    /**
     * Gets the UserActivity from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<UserActivity> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the UserActivity from the service
     *
     * @return the UserActivity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public UserActivity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<UserActivity> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserActivity with a source
     *
     * @param sourceUserActivity the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final UserActivity sourceUserActivity, final ICallback<UserActivity> callback) {
        send(HttpMethod.PATCH, callback, sourceUserActivity);
    }

    /**
     * Patches this UserActivity with a source
     *
     * @param sourceUserActivity the source object with updates
     * @return the updated UserActivity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public UserActivity patch(final UserActivity sourceUserActivity) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserActivity);
    }

    /**
     * Creates a UserActivity with a new object
     *
     * @param newUserActivity the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final UserActivity newUserActivity, final ICallback<UserActivity> callback) {
        send(HttpMethod.POST, callback, newUserActivity);
    }

    /**
     * Creates a UserActivity with a new object
     *
     * @param newUserActivity the new object to create
     * @return the created UserActivity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public UserActivity post(final UserActivity newUserActivity) throws ClientException {
        return send(HttpMethod.POST, newUserActivity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IUserActivityRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (UserActivityRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IUserActivityRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (UserActivityRequest)this;
     }

}

