// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams App Reference Request.
 */
public class TeamsAppReferenceRequest extends BaseRequest implements ITeamsAppReferenceRequest {

    /**
     * The request for the TeamsApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsAppReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsApp.class);
    }

    public void delete(final ICallback<TeamsApp> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public TeamsApp delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITeamsAppReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (TeamsAppReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITeamsAppReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (TeamsAppReferenceRequest)this;
    }
    /**
     * Puts the TeamsApp
     *
     * @param srcTeamsApp the TeamsApp reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(TeamsApp srcTeamsApp, final ICallback<TeamsApp> callback) {
        send(HttpMethod.PUT, callback, srcTeamsApp);
    }

    /**
     * Puts the TeamsApp
     *
     * @param srcTeamsApp the TeamsApp reference to PUT
     * @return the TeamsApp
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public TeamsApp put(TeamsApp srcTeamsApp) throws ClientException {
        return send(HttpMethod.PUT, srcTeamsApp);
    }
}
