// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sign In Collection Request.
 */
public class SignInCollectionRequest extends BaseCollectionRequest<SignInCollectionResponse, ISignInCollectionPage> implements ISignInCollectionRequest {

    /**
     * The request builder for this collection of SignIn
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SignInCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SignInCollectionResponse.class, ISignInCollectionPage.class);
    }

    public void get(final ICallback<ISignInCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISignInCollectionPage get() throws ClientException {
        final SignInCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final SignIn newSignIn, final ICallback<SignIn> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new SignInRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSignIn, callback);
    }

    public SignIn post(final SignIn newSignIn) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new SignInRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSignIn);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ISignInCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (SignInCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ISignInCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (SignInCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ISignInCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (SignInCollectionRequest)this;
    }

    public ISignInCollectionPage buildFromResponse(final SignInCollectionResponse response) {
        final ISignInCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SignInCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final SignInCollectionPage page = new SignInCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
