// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TelecomExpenseManagementPartner;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Telecom Expense Management Partner Request.
 */
public interface ITelecomExpenseManagementPartnerRequest extends IHttpRequest {

    /**
     * Gets the TelecomExpenseManagementPartner from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<TelecomExpenseManagementPartner> callback);

    /**
     * Gets the TelecomExpenseManagementPartner from the service
     *
     * @return the TelecomExpenseManagementPartner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TelecomExpenseManagementPartner get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<TelecomExpenseManagementPartner> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TelecomExpenseManagementPartner with a source
     *
     * @param sourceTelecomExpenseManagementPartner the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TelecomExpenseManagementPartner sourceTelecomExpenseManagementPartner, final ICallback<TelecomExpenseManagementPartner> callback);

    /**
     * Patches this TelecomExpenseManagementPartner with a source
     *
     * @param sourceTelecomExpenseManagementPartner the source object with updates
     * @return the updated TelecomExpenseManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TelecomExpenseManagementPartner patch(final TelecomExpenseManagementPartner sourceTelecomExpenseManagementPartner) throws ClientException;

    /**
     * Posts a TelecomExpenseManagementPartner with a new object
     *
     * @param newTelecomExpenseManagementPartner the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TelecomExpenseManagementPartner newTelecomExpenseManagementPartner, final ICallback<TelecomExpenseManagementPartner> callback);

    /**
     * Posts a TelecomExpenseManagementPartner with a new object
     *
     * @param newTelecomExpenseManagementPartner the new object to create
     * @return the created TelecomExpenseManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TelecomExpenseManagementPartner post(final TelecomExpenseManagementPartner newTelecomExpenseManagementPartner) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITelecomExpenseManagementPartnerRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITelecomExpenseManagementPartnerRequest expand(final String value);

}

