// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOrganizationRequest;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOrganizationSetMobileDeviceManagementAuthorityRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Organization Request Builder.
 */
public interface IOrganizationRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IOrganizationRequest instance
     */
    IOrganizationRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IOrganizationRequest instance
     */
    IOrganizationRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IExtensionCollectionRequestBuilder extensions();

    IExtensionRequestBuilder extensions(final String id);
    IOrganizationSetMobileDeviceManagementAuthorityRequestBuilder setMobileDeviceManagementAuthority();

}
