// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDomainDnsCnameRecordRequest;
import com.microsoft.graph.requests.extensions.DomainDnsCnameRecordRequest;
import com.microsoft.graph.models.extensions.DomainDnsCnameRecord;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Dns Cname Record Request.
 */
public class DomainDnsCnameRecordRequest extends BaseRequest implements IDomainDnsCnameRecordRequest {
	
    /**
     * The request for the DomainDnsCnameRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DomainDnsCnameRecordRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DomainDnsCnameRecord.class);
    }

    /**
     * Gets the DomainDnsCnameRecord from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DomainDnsCnameRecord from the service
     *
     * @return the DomainDnsCnameRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsCnameRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DomainDnsCnameRecord with a source
     *
     * @param sourceDomainDnsCnameRecord the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DomainDnsCnameRecord sourceDomainDnsCnameRecord, final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.PATCH, callback, sourceDomainDnsCnameRecord);
    }

    /**
     * Patches this DomainDnsCnameRecord with a source
     *
     * @param sourceDomainDnsCnameRecord the source object with updates
     * @return the updated DomainDnsCnameRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsCnameRecord patch(final DomainDnsCnameRecord sourceDomainDnsCnameRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomainDnsCnameRecord);
    }

    /**
     * Creates a DomainDnsCnameRecord with a new object
     *
     * @param newDomainDnsCnameRecord the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DomainDnsCnameRecord newDomainDnsCnameRecord, final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.POST, callback, newDomainDnsCnameRecord);
    }

    /**
     * Creates a DomainDnsCnameRecord with a new object
     *
     * @param newDomainDnsCnameRecord the new object to create
     * @return the created DomainDnsCnameRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DomainDnsCnameRecord post(final DomainDnsCnameRecord newDomainDnsCnameRecord) throws ClientException {
        return send(HttpMethod.POST, newDomainDnsCnameRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDomainDnsCnameRecordRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DomainDnsCnameRecordRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDomainDnsCnameRecordRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DomainDnsCnameRecordRequest)this;
     }

}

