// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Role Assignment Collection Request.
 */
public class RoleAssignmentCollectionRequest extends BaseCollectionRequest<RoleAssignmentCollectionResponse, IRoleAssignmentCollectionPage> implements IRoleAssignmentCollectionRequest {

    /**
     * The request builder for this collection of RoleAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RoleAssignmentCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleAssignmentCollectionResponse.class, IRoleAssignmentCollectionPage.class);
    }

    public void get(final ICallback<IRoleAssignmentCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IRoleAssignmentCollectionPage get() throws ClientException {
        final RoleAssignmentCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final RoleAssignment newRoleAssignment, final ICallback<RoleAssignment> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new RoleAssignmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newRoleAssignment, callback);
    }

    public RoleAssignment post(final RoleAssignment newRoleAssignment) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new RoleAssignmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newRoleAssignment);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IRoleAssignmentCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (RoleAssignmentCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IRoleAssignmentCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (RoleAssignmentCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IRoleAssignmentCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (RoleAssignmentCollectionRequest)this;
    }

    public IRoleAssignmentCollectionPage buildFromResponse(final RoleAssignmentCollectionResponse response) {
        final IRoleAssignmentCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new RoleAssignmentCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final RoleAssignmentCollectionPage page = new RoleAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
