// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IProfilePhotoRequest;
import com.microsoft.graph.requests.extensions.ProfilePhotoRequest;
import com.microsoft.graph.requests.extensions.IProfilePhotoStreamRequestBuilder;
import com.microsoft.graph.requests.extensions.ProfilePhotoStreamRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Profile Photo Request Builder.
 */
public class ProfilePhotoRequestBuilder extends BaseRequestBuilder implements IProfilePhotoRequestBuilder {

    /**
     * The request builder for the ProfilePhoto
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ProfilePhotoRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IProfilePhotoRequest instance
     */
    public IProfilePhotoRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IProfilePhotoRequest instance
     */
    public IProfilePhotoRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ProfilePhotoRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IProfilePhotoStreamRequestBuilder content() {
        return new ProfilePhotoStreamRequestBuilder(getRequestUrlWithAdditionalSegment("$value"), getClient(), null);
    }
}

