// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceWindowsDefenderUpdateSignaturesRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceWindowsDefenderUpdateSignaturesRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Windows Defender Update Signatures Request Builder.
 */
public class ManagedDeviceWindowsDefenderUpdateSignaturesRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceWindowsDefenderUpdateSignaturesRequestBuilder {

    /**
     * The request builder for this ManagedDeviceWindowsDefenderUpdateSignatures
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceWindowsDefenderUpdateSignaturesRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IManagedDeviceWindowsDefenderUpdateSignaturesRequest
     *
     * @return the IManagedDeviceWindowsDefenderUpdateSignaturesRequest instance
     */
    public IManagedDeviceWindowsDefenderUpdateSignaturesRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IManagedDeviceWindowsDefenderUpdateSignaturesRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceWindowsDefenderUpdateSignaturesRequest instance
     */
    public IManagedDeviceWindowsDefenderUpdateSignaturesRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        ManagedDeviceWindowsDefenderUpdateSignaturesRequest request = new ManagedDeviceWindowsDefenderUpdateSignaturesRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
