// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedAppConfigurationRequest;
import com.microsoft.graph.requests.extensions.ManagedAppConfigurationRequest;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Configuration Request Builder.
 */
public class ManagedAppConfigurationRequestBuilder extends BaseRequestBuilder implements IManagedAppConfigurationRequestBuilder {

    /**
     * The request builder for the ManagedAppConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedAppConfigurationRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IManagedAppConfigurationRequest instance
     */
    public IManagedAppConfigurationRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IManagedAppConfigurationRequest instance
     */
    public IManagedAppConfigurationRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ManagedAppConfigurationRequest(getRequestUrl(), getClient(), requestOptions);
    }


}

