// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartAxisTitleFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Axis Title Format Request.
 */
public interface IWorkbookChartAxisTitleFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxisTitleFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Gets the WorkbookChartAxisTitleFormat from the service
     *
     * @return the WorkbookChartAxisTitleFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitleFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxisTitleFormat with a source
     *
     * @param sourceWorkbookChartAxisTitleFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartAxisTitleFormat sourceWorkbookChartAxisTitleFormat, final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Patches this WorkbookChartAxisTitleFormat with a source
     *
     * @param sourceWorkbookChartAxisTitleFormat the source object with updates
     * @return the updated WorkbookChartAxisTitleFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitleFormat patch(final WorkbookChartAxisTitleFormat sourceWorkbookChartAxisTitleFormat) throws ClientException;

    /**
     * Posts a WorkbookChartAxisTitleFormat with a new object
     *
     * @param newWorkbookChartAxisTitleFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartAxisTitleFormat newWorkbookChartAxisTitleFormat, final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Posts a WorkbookChartAxisTitleFormat with a new object
     *
     * @param newWorkbookChartAxisTitleFormat the new object to create
     * @return the created WorkbookChartAxisTitleFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitleFormat post(final WorkbookChartAxisTitleFormat newWorkbookChartAxisTitleFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartAxisTitleFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartAxisTitleFormatRequest expand(final String value);

}

