// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Permission;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Permission Request.
 */
public interface IPermissionRequest extends IHttpRequest {

    /**
     * Gets the Permission from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Permission> callback);

    /**
     * Gets the Permission from the service
     *
     * @return the Permission from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Permission get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Permission> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Permission with a source
     *
     * @param sourcePermission the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Permission sourcePermission, final ICallback<Permission> callback);

    /**
     * Patches this Permission with a source
     *
     * @param sourcePermission the source object with updates
     * @return the updated Permission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Permission patch(final Permission sourcePermission) throws ClientException;

    /**
     * Posts a Permission with a new object
     *
     * @param newPermission the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Permission newPermission, final ICallback<Permission> callback);

    /**
     * Posts a Permission with a new object
     *
     * @param newPermission the new object to create
     * @return the created Permission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Permission post(final Permission newPermission) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPermissionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPermissionRequest expand(final String value);

}

