// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IIosManagedAppProtectionRequest;
import com.microsoft.graph.requests.extensions.IManagedMobileAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IManagedMobileAppRequestBuilder;
import com.microsoft.graph.requests.extensions.IManagedAppPolicyDeploymentSummaryRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Ios Managed App Protection Request Builder.
 */
public interface IIosManagedAppProtectionRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IIosManagedAppProtectionRequest instance
     */
    IIosManagedAppProtectionRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IIosManagedAppProtectionRequest instance
     */
    IIosManagedAppProtectionRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IManagedMobileAppCollectionRequestBuilder apps();

    IManagedMobileAppRequestBuilder apps(final String id);

    /**
     * Gets the request builder for ManagedAppPolicyDeploymentSummary
     *
     * @return the IManagedAppPolicyDeploymentSummaryRequestBuilder instance
     */
    IManagedAppPolicyDeploymentSummaryRequestBuilder deploymentSummary();

}
