// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Reference Request.
 */
public class GroupReferenceRequest extends BaseRequest implements IGroupReferenceRequest {

    /**
     * The request for the Group
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Group.class);
    }

    public void delete(final ICallback<Group> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public Group delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IGroupReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (GroupReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IGroupReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (GroupReferenceRequest)this;
    }
    /**
     * Puts the Group
     *
     * @param srcGroup the Group reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(Group srcGroup, final ICallback<Group> callback) {
        send(HttpMethod.PUT, callback, srcGroup);
    }

    /**
     * Puts the Group
     *
     * @param srcGroup the Group reference to PUT
     * @return the Group
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public Group put(Group srcGroup) throws ClientException {
        return send(HttpMethod.PUT, srcGroup);
    }
}
