// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Collection Request.
 */
public class NotebookCollectionRequest extends BaseCollectionRequest<NotebookCollectionResponse, INotebookCollectionPage> implements INotebookCollectionRequest {

    /**
     * The request builder for this collection of Notebook
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NotebookCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NotebookCollectionResponse.class, INotebookCollectionPage.class);
    }

    public void get(final ICallback<INotebookCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public INotebookCollectionPage get() throws ClientException {
        final NotebookCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Notebook newNotebook, final ICallback<Notebook> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new NotebookRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newNotebook, callback);
    }

    public Notebook post(final Notebook newNotebook) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new NotebookRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newNotebook);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public INotebookCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (NotebookCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public INotebookCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (NotebookCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public INotebookCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (NotebookCollectionRequest)this;
    }

    public INotebookCollectionPage buildFromResponse(final NotebookCollectionResponse response) {
        final INotebookCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new NotebookCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final NotebookCollectionPage page = new NotebookCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
