// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IItemAttachmentRequest;
import com.microsoft.graph.requests.extensions.ItemAttachmentRequest;
import com.microsoft.graph.requests.extensions.IOutlookItemRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookItemRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Attachment Request Builder.
 */
public class ItemAttachmentRequestBuilder extends BaseRequestBuilder implements IItemAttachmentRequestBuilder {

    /**
     * The request builder for the ItemAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemAttachmentRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IItemAttachmentRequest instance
     */
    public IItemAttachmentRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IItemAttachmentRequest instance
     */
    public IItemAttachmentRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ItemAttachmentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for OutlookItem
     *
     * @return the IOutlookItemRequestBuilder instance
     */
    public IOutlookItemRequestBuilder item() {
        return new OutlookItemRequestBuilder(getRequestUrlWithAdditionalSegment("item"), getClient(), null);
    }
}

