// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Configuration Request.
 */
public interface IDeviceConfigurationRequest extends IHttpRequest {

    /**
     * Gets the DeviceConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DeviceConfiguration> callback);

    /**
     * Gets the DeviceConfiguration from the service
     *
     * @return the DeviceConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfiguration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DeviceConfiguration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceConfiguration with a source
     *
     * @param sourceDeviceConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceConfiguration sourceDeviceConfiguration, final ICallback<DeviceConfiguration> callback);

    /**
     * Patches this DeviceConfiguration with a source
     *
     * @param sourceDeviceConfiguration the source object with updates
     * @return the updated DeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfiguration patch(final DeviceConfiguration sourceDeviceConfiguration) throws ClientException;

    /**
     * Posts a DeviceConfiguration with a new object
     *
     * @param newDeviceConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceConfiguration newDeviceConfiguration, final ICallback<DeviceConfiguration> callback);

    /**
     * Posts a DeviceConfiguration with a new object
     *
     * @param newDeviceConfiguration the new object to create
     * @return the created DeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfiguration post(final DeviceConfiguration newDeviceConfiguration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceConfigurationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceConfigurationRequest expand(final String value);

}

