// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AuditLogRoot;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Audit Log Root Request.
 */
public interface IAuditLogRootRequest extends IHttpRequest {

    /**
     * Gets the AuditLogRoot from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<AuditLogRoot> callback);

    /**
     * Gets the AuditLogRoot from the service
     *
     * @return the AuditLogRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuditLogRoot get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<AuditLogRoot> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AuditLogRoot with a source
     *
     * @param sourceAuditLogRoot the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AuditLogRoot sourceAuditLogRoot, final ICallback<AuditLogRoot> callback);

    /**
     * Patches this AuditLogRoot with a source
     *
     * @param sourceAuditLogRoot the source object with updates
     * @return the updated AuditLogRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuditLogRoot patch(final AuditLogRoot sourceAuditLogRoot) throws ClientException;

    /**
     * Posts a AuditLogRoot with a new object
     *
     * @param newAuditLogRoot the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AuditLogRoot newAuditLogRoot, final ICallback<AuditLogRoot> callback);

    /**
     * Posts a AuditLogRoot with a new object
     *
     * @param newAuditLogRoot the new object to create
     * @return the created AuditLogRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AuditLogRoot post(final AuditLogRoot newAuditLogRoot) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAuditLogRootRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAuditLogRootRequest expand(final String value);

}

