// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Class With Reference Request.
 */
public class EducationClassWithReferenceRequest extends BaseRequest implements IEducationClassWithReferenceRequest {

    /**
     * The request for the EducationClass
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationClassWithReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationClass.class);
    }

    public void post(final EducationClass newEducationClass, final IJsonBackedObject payload, final ICallback<EducationClass> callback) {
        send(HttpMethod.POST, callback, payload);
    }

    public EducationClass post(final EducationClass newEducationClass, final IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = send(HttpMethod.POST, payload);
        if (response != null){
            return newEducationClass;
        }
        return null;
    }

    public void get(final ICallback<EducationClass> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public EducationClass get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

	public void delete(final ICallback<EducationClass> callback) {
		send(HttpMethod.DELETE, callback, null);
	}

	public void delete() throws ClientException {
		send(HttpMethod.DELETE, null);
	}

	public void patch(final EducationClass sourceEducationClass, final ICallback<EducationClass> callback) {
		send(HttpMethod.PATCH, callback, sourceEducationClass);
	}

	public EducationClass patch(final EducationClass sourceEducationClass) throws ClientException {
		return send(HttpMethod.PATCH, sourceEducationClass);
	}


    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IEducationClassWithReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (IEducationClassWithReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IEducationClassWithReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EducationClassWithReferenceRequest)this;
    }
}
