// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Contract Collection Request.
 */
public class ContractCollectionRequest extends BaseCollectionRequest<ContractCollectionResponse, IContractCollectionPage> implements IContractCollectionRequest {

    /**
     * The request builder for this collection of Contract
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContractCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContractCollectionResponse.class, IContractCollectionPage.class);
    }

    public void get(final ICallback<IContractCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IContractCollectionPage get() throws ClientException {
        final ContractCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Contract newContract, final ICallback<Contract> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ContractRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newContract, callback);
    }

    public Contract post(final Contract newContract) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ContractRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newContract);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IContractCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ContractCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IContractCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ContractCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IContractCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ContractCollectionRequest)this;
    }

    public IContractCollectionPage buildFromResponse(final ContractCollectionResponse response) {
        final IContractCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ContractCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ContractCollectionPage page = new ContractCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
