/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.net.URL;
import java.util.List;

public abstract class BaseCollectionRequest<T1, T2>
implements IHttpRequest {
    private final BaseRequest baseRequest;
    private final Class<T1> responseClass;
    private final Class<T2> collectionPageClass;

    public BaseCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> options, Class<T1> responseClass, Class<T2> collectionPageClass) {
        this.responseClass = responseClass;
        this.collectionPageClass = collectionPageClass;
        this.baseRequest = new BaseRequest(requestUrl, client, options, responseClass){};
    }

    protected T1 send() throws ClientException {
        this.baseRequest.setHttpMethod(HttpMethod.GET);
        return this.baseRequest.getClient().getHttpProvider().send(this, this.responseClass, null);
    }

    protected <BodyType> T1 post(BodyType serializedObject) throws ClientException {
        this.baseRequest.setHttpMethod(HttpMethod.POST);
        return this.baseRequest.getClient().getHttpProvider().send(this, this.responseClass, serializedObject);
    }

    @Override
    public URL getRequestUrl() {
        return this.baseRequest.getRequestUrl();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.baseRequest.getHttpMethod();
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.baseRequest.getHeaders();
    }

    @Override
    public void addHeader(String header, String value) {
        this.baseRequest.addHeader(header, value);
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.baseRequest.setUseCaches(useCaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.baseRequest.getUseCaches();
    }

    @Override
    public List<Option> getOptions() {
        return this.baseRequest.getOptions();
    }

    public void addQueryOption(QueryOption option) {
        this.baseRequest.getQueryOptions().add(option);
    }

    public void addFunctionOption(FunctionOption option) {
        this.baseRequest.getFunctionOptions().add(option);
    }

    protected BaseRequest getBaseRequest() {
        return this.baseRequest;
    }

    public Class<T2> getCollectionPageClass() {
        return this.collectionPageClass;
    }
}

