// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WindowsUniversalAppX;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows Universal App XRequest.
 */
public interface IWindowsUniversalAppXRequest extends IHttpRequest {

    /**
     * Gets the WindowsUniversalAppX from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WindowsUniversalAppX> callback);

    /**
     * Gets the WindowsUniversalAppX from the service
     *
     * @return the WindowsUniversalAppX from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsUniversalAppX get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WindowsUniversalAppX> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WindowsUniversalAppX with a source
     *
     * @param sourceWindowsUniversalAppX the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WindowsUniversalAppX sourceWindowsUniversalAppX, final ICallback<WindowsUniversalAppX> callback);

    /**
     * Patches this WindowsUniversalAppX with a source
     *
     * @param sourceWindowsUniversalAppX the source object with updates
     * @return the updated WindowsUniversalAppX
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsUniversalAppX patch(final WindowsUniversalAppX sourceWindowsUniversalAppX) throws ClientException;

    /**
     * Posts a WindowsUniversalAppX with a new object
     *
     * @param newWindowsUniversalAppX the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WindowsUniversalAppX newWindowsUniversalAppX, final ICallback<WindowsUniversalAppX> callback);

    /**
     * Posts a WindowsUniversalAppX with a new object
     *
     * @param newWindowsUniversalAppX the new object to create
     * @return the created WindowsUniversalAppX
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsUniversalAppX post(final WindowsUniversalAppX newWindowsUniversalAppX) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindowsUniversalAppXRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindowsUniversalAppXRequest expand(final String value);

}

