// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IThumbnailSetRequest;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Thumbnail Set Request Builder.
 */
public interface IThumbnailSetRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IThumbnailSetRequest instance
     */
    IThumbnailSetRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IThumbnailSetRequest instance
     */
    IThumbnailSetRequest buildRequest(final java.util.List<? extends Option> requestOptions);

    /**
     * Gets a request for a thumbnail of a specific size
     * @param size The size to request (typically: small, medium, large)
     * @return The request builder for that thumbnail size
     */
    IThumbnailRequestBuilder getThumbnailSize(final String size);

}
