// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IMessageRequest;
import com.microsoft.graph.requests.extensions.IAttachmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAttachmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageCopyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageMoveRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageCreateReplyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageCreateReplyAllRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageCreateForwardRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageReplyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageReplyAllRequestBuilder;
import com.microsoft.graph.models.extensions.Recipient;
import com.microsoft.graph.requests.extensions.IMessageForwardRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageSendRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Message Request Builder.
 */
public interface IMessageRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IMessageRequest instance
     */
    IMessageRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IMessageRequest instance
     */
    IMessageRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IAttachmentCollectionRequestBuilder attachments();

    IAttachmentRequestBuilder attachments(final String id);

    IExtensionCollectionRequestBuilder extensions();

    IExtensionRequestBuilder extensions(final String id);

    ISingleValueLegacyExtendedPropertyCollectionRequestBuilder singleValueExtendedProperties();

    ISingleValueLegacyExtendedPropertyRequestBuilder singleValueExtendedProperties(final String id);

    IMultiValueLegacyExtendedPropertyCollectionRequestBuilder multiValueExtendedProperties();

    IMultiValueLegacyExtendedPropertyRequestBuilder multiValueExtendedProperties(final String id);
    IMessageCopyRequestBuilder copy(final String destinationId);
    IMessageMoveRequestBuilder move(final String destinationId);
    IMessageCreateReplyRequestBuilder createReply();
    IMessageCreateReplyAllRequestBuilder createReplyAll();
    IMessageCreateForwardRequestBuilder createForward();
    IMessageReplyRequestBuilder reply(final String comment);
    IMessageReplyAllRequestBuilder replyAll(final String comment);
    IMessageForwardRequestBuilder forward(final String comment, final java.util.List<Recipient> toRecipients);
    IMessageSendRequestBuilder send();

}
