// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEducationSchoolRequest;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserWithReferenceRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Education School Request Builder.
 */
public interface IEducationSchoolRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IEducationSchoolRequest instance
     */
    IEducationSchoolRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IEducationSchoolRequest instance
     */
    IEducationSchoolRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IEducationClassCollectionWithReferencesRequestBuilder classes();

    IEducationClassWithReferenceRequestBuilder classes(final String id);

    IEducationUserCollectionWithReferencesRequestBuilder users();

    IEducationUserWithReferenceRequestBuilder users(final String id);

}
