// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education School Reference Request.
 */
public class EducationSchoolReferenceRequest extends BaseRequest implements IEducationSchoolReferenceRequest {

    /**
     * The request for the EducationSchool
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationSchoolReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSchool.class);
    }

    public void delete(final ICallback<EducationSchool> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public EducationSchool delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IEducationSchoolReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (EducationSchoolReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IEducationSchoolReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EducationSchoolReferenceRequest)this;
    }
    /**
     * Puts the EducationSchool
     *
     * @param srcEducationSchool the EducationSchool reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(EducationSchool srcEducationSchool, final ICallback<EducationSchool> callback) {
        send(HttpMethod.PUT, callback, srcEducationSchool);
    }

    /**
     * Puts the EducationSchool
     *
     * @param srcEducationSchool the EducationSchool reference to PUT
     * @return the EducationSchool
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public EducationSchool put(EducationSchool srcEducationSchool) throws ClientException {
        return send(HttpMethod.PUT, srcEducationSchool);
    }
}
