/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.UsedInsight;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUsedInsightCollectionPage;
import com.microsoft.graph.requests.extensions.IUsedInsightCollectionRequest;
import com.microsoft.graph.requests.extensions.UsedInsightCollectionPage;
import com.microsoft.graph.requests.extensions.UsedInsightCollectionRequest;
import com.microsoft.graph.requests.extensions.UsedInsightCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UsedInsightRequestBuilder;
import com.microsoft.graph.requests.generated.BaseUsedInsightCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseUsedInsightCollectionRequest;
import java.util.List;

public class BaseUsedInsightCollectionRequest
extends BaseCollectionRequest<BaseUsedInsightCollectionResponse, IUsedInsightCollectionPage>
implements IBaseUsedInsightCollectionRequest {
    public BaseUsedInsightCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseUsedInsightCollectionResponse.class, IUsedInsightCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUsedInsightCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseUsedInsightCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUsedInsightCollectionPage get() throws ClientException {
        BaseUsedInsightCollectionResponse response = (BaseUsedInsightCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UsedInsight newUsedInsight, ICallback<UsedInsight> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UsedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUsedInsight, callback);
    }

    @Override
    public UsedInsight post(UsedInsight newUsedInsight) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UsedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUsedInsight);
    }

    @Override
    public IUsedInsightCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (UsedInsightCollectionRequest)this;
    }

    @Override
    public IUsedInsightCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (UsedInsightCollectionRequest)this;
    }

    @Override
    public IUsedInsightCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (UsedInsightCollectionRequest)this;
    }

    public IUsedInsightCollectionPage buildFromResponse(BaseUsedInsightCollectionResponse response) {
        UsedInsightCollectionRequestBuilder builder = response.nextLink != null ? new UsedInsightCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UsedInsightCollectionPage page = new UsedInsightCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

