/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsAppInstallation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsAppInstallationCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsAppInstallationCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTeamsAppInstallationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTeamsAppInstallationCollectionRequest;
import java.util.List;

public class BaseTeamsAppInstallationCollectionRequest
extends BaseCollectionRequest<BaseTeamsAppInstallationCollectionResponse, ITeamsAppInstallationCollectionPage>
implements IBaseTeamsAppInstallationCollectionRequest {
    public BaseTeamsAppInstallationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTeamsAppInstallationCollectionResponse.class, ITeamsAppInstallationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsAppInstallationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTeamsAppInstallationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsAppInstallationCollectionPage get() throws ClientException {
        BaseTeamsAppInstallationCollectionResponse response = (BaseTeamsAppInstallationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsAppInstallation newTeamsAppInstallation, ICallback<TeamsAppInstallation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsAppInstallationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsAppInstallation, callback);
    }

    @Override
    public TeamsAppInstallation post(TeamsAppInstallation newTeamsAppInstallation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsAppInstallationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsAppInstallation);
    }

    @Override
    public ITeamsAppInstallationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TeamsAppInstallationCollectionRequest)this;
    }

    @Override
    public ITeamsAppInstallationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TeamsAppInstallationCollectionRequest)this;
    }

    @Override
    public ITeamsAppInstallationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TeamsAppInstallationCollectionRequest)this;
    }

    public ITeamsAppInstallationCollectionPage buildFromResponse(BaseTeamsAppInstallationCollectionResponse response) {
        TeamsAppInstallationCollectionRequestBuilder builder = response.nextLink != null ? new TeamsAppInstallationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsAppInstallationCollectionPage page = new TeamsAppInstallationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

