/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.generated.BaseManagedDeviceCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseManagedDeviceCollectionWithReferencesRequest;
import java.util.List;

public class BaseManagedDeviceCollectionWithReferencesRequest
extends BaseCollectionRequest<BaseManagedDeviceCollectionResponse, IManagedDeviceCollectionPage>
implements IBaseManagedDeviceCollectionWithReferencesRequest {
    public BaseManagedDeviceCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseManagedDeviceCollectionResponse.class, IManagedDeviceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedDeviceCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseManagedDeviceCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedDeviceCollectionWithReferencesPage get() throws ClientException {
        BaseManagedDeviceCollectionResponse response = (BaseManagedDeviceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IManagedDeviceCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ManagedDeviceCollectionWithReferencesRequest)this;
    }

    @Override
    public IManagedDeviceCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ManagedDeviceCollectionWithReferencesRequest)this;
    }

    @Override
    public IManagedDeviceCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ManagedDeviceCollectionWithReferencesRequest)this;
    }

    public IManagedDeviceCollectionWithReferencesPage buildFromResponse(BaseManagedDeviceCollectionResponse response) {
        ManagedDeviceCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new ManagedDeviceCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedDeviceCollectionWithReferencesPage page = new ManagedDeviceCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

