/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.EducationUser;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationUserCollectionPage;
import com.microsoft.graph.requests.extensions.EducationUserCollectionRequest;
import com.microsoft.graph.requests.extensions.EducationUserCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EducationUserRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionRequest;
import com.microsoft.graph.requests.generated.BaseEducationUserCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseEducationUserCollectionRequest;
import java.util.List;

public class BaseEducationUserCollectionRequest
extends BaseCollectionRequest<BaseEducationUserCollectionResponse, IEducationUserCollectionPage>
implements IBaseEducationUserCollectionRequest {
    public BaseEducationUserCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationUserCollectionResponse.class, IEducationUserCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEducationUserCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseEducationUserCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationUserCollectionPage get() throws ClientException {
        BaseEducationUserCollectionResponse response = (BaseEducationUserCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EducationUser newEducationUser, ICallback<EducationUser> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EducationUserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationUser, callback);
    }

    @Override
    public EducationUser post(EducationUser newEducationUser) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EducationUserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationUser);
    }

    @Override
    public IEducationUserCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EducationUserCollectionRequest)this;
    }

    @Override
    public IEducationUserCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EducationUserCollectionRequest)this;
    }

    @Override
    public IEducationUserCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EducationUserCollectionRequest)this;
    }

    public IEducationUserCollectionPage buildFromResponse(BaseEducationUserCollectionResponse response) {
        EducationUserCollectionRequestBuilder builder = response.nextLink != null ? new EducationUserCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationUserCollectionPage page = new EducationUserCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

