/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveItemSearchCollectionPage;
import com.microsoft.graph.requests.extensions.DriveItemSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemSearchCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveItemSearchCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDriveItemSearchCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDriveItemSearchCollectionRequest;
import java.util.List;

public class BaseDriveItemSearchCollectionRequest
extends BaseCollectionRequest<BaseDriveItemSearchCollectionResponse, IDriveItemSearchCollectionPage>
implements IBaseDriveItemSearchCollectionRequest {
    public BaseDriveItemSearchCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDriveItemSearchCollectionResponse.class, IDriveItemSearchCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemSearchCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveItemSearchCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemSearchCollectionPage get() throws ClientException {
        BaseDriveItemSearchCollectionResponse response = (BaseDriveItemSearchCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveItemSearchCollectionPage buildFromResponse(BaseDriveItemSearchCollectionResponse response) {
        DriveItemSearchCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemSearchCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DriveItemSearchCollectionPage page = new DriveItemSearchCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveItemSearchCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDriveItemSearchCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemSearchCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDriveItemSearchCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemSearchCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDriveItemSearchCollectionRequest)((Object)this);
    }
}

