/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryRoleDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryRoleDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryRoleDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryRoleDeltaCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDirectoryRoleDeltaCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDirectoryRoleDeltaCollectionRequest;
import java.util.List;

public class BaseDirectoryRoleDeltaCollectionRequest
extends BaseCollectionRequest<BaseDirectoryRoleDeltaCollectionResponse, IDirectoryRoleDeltaCollectionPage>
implements IBaseDirectoryRoleDeltaCollectionRequest {
    public BaseDirectoryRoleDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDirectoryRoleDeltaCollectionResponse.class, IDirectoryRoleDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDirectoryRoleDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDirectoryRoleDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryRoleDeltaCollectionPage get() throws ClientException {
        BaseDirectoryRoleDeltaCollectionResponse response = (BaseDirectoryRoleDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDirectoryRoleDeltaCollectionPage buildFromResponse(BaseDirectoryRoleDeltaCollectionResponse response) {
        DirectoryRoleDeltaCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryRoleDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DirectoryRoleDeltaCollectionPage page = new DirectoryRoleDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryRoleDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDirectoryRoleDeltaCollectionRequest)((Object)this);
    }

    @Override
    public IDirectoryRoleDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDirectoryRoleDeltaCollectionRequest)((Object)this);
    }

    @Override
    public IDirectoryRoleDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDirectoryRoleDeltaCollectionRequest)((Object)this);
    }
}

