/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DataPolicyOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DataPolicyOperationCollectionPage;
import com.microsoft.graph.requests.extensions.DataPolicyOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.DataPolicyOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DataPolicyOperationRequestBuilder;
import com.microsoft.graph.requests.extensions.IDataPolicyOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IDataPolicyOperationCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDataPolicyOperationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDataPolicyOperationCollectionRequest;
import java.util.List;

public class BaseDataPolicyOperationCollectionRequest
extends BaseCollectionRequest<BaseDataPolicyOperationCollectionResponse, IDataPolicyOperationCollectionPage>
implements IBaseDataPolicyOperationCollectionRequest {
    public BaseDataPolicyOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDataPolicyOperationCollectionResponse.class, IDataPolicyOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDataPolicyOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDataPolicyOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDataPolicyOperationCollectionPage get() throws ClientException {
        BaseDataPolicyOperationCollectionResponse response = (BaseDataPolicyOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DataPolicyOperation newDataPolicyOperation, ICallback<DataPolicyOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DataPolicyOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDataPolicyOperation, callback);
    }

    @Override
    public DataPolicyOperation post(DataPolicyOperation newDataPolicyOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DataPolicyOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDataPolicyOperation);
    }

    @Override
    public IDataPolicyOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DataPolicyOperationCollectionRequest)this;
    }

    @Override
    public IDataPolicyOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DataPolicyOperationCollectionRequest)this;
    }

    @Override
    public IDataPolicyOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DataPolicyOperationCollectionRequest)this;
    }

    public IDataPolicyOperationCollectionPage buildFromResponse(BaseDataPolicyOperationCollectionResponse response) {
        DataPolicyOperationCollectionRequestBuilder builder = response.nextLink != null ? new DataPolicyOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DataPolicyOperationCollectionPage page = new DataPolicyOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

