/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Channel;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ChannelRequest;
import com.microsoft.graph.requests.extensions.IChannelRequest;
import com.microsoft.graph.requests.generated.IBaseChannelRequest;
import java.util.List;

public class BaseChannelRequest
extends BaseRequest
implements IBaseChannelRequest {
    public BaseChannelRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<Channel> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    @Override
    public void get(ICallback<Channel> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Channel get() throws ClientException {
        return (Channel)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Channel> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Channel sourceChannel, ICallback<Channel> callback) {
        this.send(HttpMethod.PATCH, callback, sourceChannel);
    }

    @Override
    public Channel patch(Channel sourceChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.PATCH, sourceChannel);
    }

    @Override
    public void post(Channel newChannel, ICallback<Channel> callback) {
        this.send(HttpMethod.POST, callback, newChannel);
    }

    @Override
    public Channel post(Channel newChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.POST, newChannel);
    }

    @Override
    public IChannelRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (ChannelRequest)this;
    }

    @Override
    public IChannelRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (ChannelRequest)this;
    }
}

