/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WorkbookChart;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWorkbookChartCollectionPage;
import com.microsoft.graph.requests.extensions.IWorkbookChartCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookChartCollectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartRequestBuilder;
import com.microsoft.graph.requests.generated.BaseWorkbookChartCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseWorkbookChartCollectionRequest;
import java.util.List;

public class BaseWorkbookChartCollectionRequest
extends BaseCollectionRequest<BaseWorkbookChartCollectionResponse, IWorkbookChartCollectionPage>
implements IBaseWorkbookChartCollectionRequest {
    public BaseWorkbookChartCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookChartCollectionResponse.class, IWorkbookChartCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookChartCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookChartCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookChartCollectionPage get() throws ClientException {
        BaseWorkbookChartCollectionResponse response = (BaseWorkbookChartCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookChart newWorkbookChart, ICallback<WorkbookChart> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookChartRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookChart, callback);
    }

    @Override
    public WorkbookChart post(WorkbookChart newWorkbookChart) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookChartRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookChart);
    }

    @Override
    public IWorkbookChartCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookChartCollectionRequest)this;
    }

    @Override
    public IWorkbookChartCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookChartCollectionRequest)this;
    }

    @Override
    public IWorkbookChartCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookChartCollectionRequest)this;
    }

    public IWorkbookChartCollectionPage buildFromResponse(BaseWorkbookChartCollectionResponse response) {
        WorkbookChartCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookChartCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookChartCollectionPage page = new WorkbookChartCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

