/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserActivityRecentCollectionPage;
import com.microsoft.graph.requests.extensions.IUserActivityRecentCollectionRequest;
import com.microsoft.graph.requests.extensions.UserActivityRecentCollectionPage;
import com.microsoft.graph.requests.extensions.UserActivityRecentCollectionRequestBuilder;
import com.microsoft.graph.requests.generated.BaseUserActivityRecentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseUserActivityRecentCollectionRequest;
import java.util.List;

public class BaseUserActivityRecentCollectionRequest
extends BaseCollectionRequest<BaseUserActivityRecentCollectionResponse, IUserActivityRecentCollectionPage>
implements IBaseUserActivityRecentCollectionRequest {
    public BaseUserActivityRecentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseUserActivityRecentCollectionResponse.class, IUserActivityRecentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUserActivityRecentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseUserActivityRecentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserActivityRecentCollectionPage get() throws ClientException {
        BaseUserActivityRecentCollectionResponse response = (BaseUserActivityRecentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IUserActivityRecentCollectionPage buildFromResponse(BaseUserActivityRecentCollectionResponse response) {
        UserActivityRecentCollectionRequestBuilder builder = response.nextLink != null ? new UserActivityRecentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserActivityRecentCollectionPage page = new UserActivityRecentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IUserActivityRecentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IUserActivityRecentCollectionRequest)((Object)this);
    }

    @Override
    public IUserActivityRecentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IUserActivityRecentCollectionRequest)((Object)this);
    }

    @Override
    public IUserActivityRecentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IUserActivityRecentCollectionRequest)((Object)this);
    }
}

