/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SubscribedSku;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISubscribedSkuCollectionPage;
import com.microsoft.graph.requests.extensions.ISubscribedSkuCollectionRequest;
import com.microsoft.graph.requests.extensions.SubscribedSkuCollectionPage;
import com.microsoft.graph.requests.extensions.SubscribedSkuCollectionRequest;
import com.microsoft.graph.requests.extensions.SubscribedSkuCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SubscribedSkuRequestBuilder;
import com.microsoft.graph.requests.generated.BaseSubscribedSkuCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseSubscribedSkuCollectionRequest;
import java.util.List;

public class BaseSubscribedSkuCollectionRequest
extends BaseCollectionRequest<BaseSubscribedSkuCollectionResponse, ISubscribedSkuCollectionPage>
implements IBaseSubscribedSkuCollectionRequest {
    public BaseSubscribedSkuCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSubscribedSkuCollectionResponse.class, ISubscribedSkuCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISubscribedSkuCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSubscribedSkuCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISubscribedSkuCollectionPage get() throws ClientException {
        BaseSubscribedSkuCollectionResponse response = (BaseSubscribedSkuCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SubscribedSku newSubscribedSku, ICallback<SubscribedSku> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSubscribedSku, callback);
    }

    @Override
    public SubscribedSku post(SubscribedSku newSubscribedSku) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSubscribedSku);
    }

    @Override
    public ISubscribedSkuCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SubscribedSkuCollectionRequest)this;
    }

    @Override
    public ISubscribedSkuCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SubscribedSkuCollectionRequest)this;
    }

    @Override
    public ISubscribedSkuCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SubscribedSkuCollectionRequest)this;
    }

    public ISubscribedSkuCollectionPage buildFromResponse(BaseSubscribedSkuCollectionResponse response) {
        SubscribedSkuCollectionRequestBuilder builder = response.nextLink != null ? new SubscribedSkuCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SubscribedSkuCollectionPage page = new SubscribedSkuCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

