/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileThreatDefenseConnector;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileThreatDefenseConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileThreatDefenseConnectorCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileThreatDefenseConnectorCollectionPage;
import com.microsoft.graph.requests.extensions.MobileThreatDefenseConnectorCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileThreatDefenseConnectorCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileThreatDefenseConnectorRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMobileThreatDefenseConnectorCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMobileThreatDefenseConnectorCollectionRequest;
import java.util.List;

public class BaseMobileThreatDefenseConnectorCollectionRequest
extends BaseCollectionRequest<BaseMobileThreatDefenseConnectorCollectionResponse, IMobileThreatDefenseConnectorCollectionPage>
implements IBaseMobileThreatDefenseConnectorCollectionRequest {
    public BaseMobileThreatDefenseConnectorCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMobileThreatDefenseConnectorCollectionResponse.class, IMobileThreatDefenseConnectorCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileThreatDefenseConnectorCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMobileThreatDefenseConnectorCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileThreatDefenseConnectorCollectionPage get() throws ClientException {
        BaseMobileThreatDefenseConnectorCollectionResponse response = (BaseMobileThreatDefenseConnectorCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileThreatDefenseConnector newMobileThreatDefenseConnector, ICallback<MobileThreatDefenseConnector> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileThreatDefenseConnectorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileThreatDefenseConnector, callback);
    }

    @Override
    public MobileThreatDefenseConnector post(MobileThreatDefenseConnector newMobileThreatDefenseConnector) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileThreatDefenseConnectorRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileThreatDefenseConnector);
    }

    @Override
    public IMobileThreatDefenseConnectorCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MobileThreatDefenseConnectorCollectionRequest)this;
    }

    @Override
    public IMobileThreatDefenseConnectorCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MobileThreatDefenseConnectorCollectionRequest)this;
    }

    @Override
    public IMobileThreatDefenseConnectorCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MobileThreatDefenseConnectorCollectionRequest)this;
    }

    public IMobileThreatDefenseConnectorCollectionPage buildFromResponse(BaseMobileThreatDefenseConnectorCollectionResponse response) {
        MobileThreatDefenseConnectorCollectionRequestBuilder builder = response.nextLink != null ? new MobileThreatDefenseConnectorCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileThreatDefenseConnectorCollectionPage page = new MobileThreatDefenseConnectorCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

