/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileAppAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentRequestBuilder;
import com.microsoft.graph.requests.generated.BaseMobileAppAssignmentCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseMobileAppAssignmentCollectionRequest;
import java.util.List;

public class BaseMobileAppAssignmentCollectionRequest
extends BaseCollectionRequest<BaseMobileAppAssignmentCollectionResponse, IMobileAppAssignmentCollectionPage>
implements IBaseMobileAppAssignmentCollectionRequest {
    public BaseMobileAppAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMobileAppAssignmentCollectionResponse.class, IMobileAppAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseMobileAppAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppAssignmentCollectionPage get() throws ClientException {
        BaseMobileAppAssignmentCollectionResponse response = (BaseMobileAppAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileAppAssignment newMobileAppAssignment, ICallback<MobileAppAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppAssignment, callback);
    }

    @Override
    public MobileAppAssignment post(MobileAppAssignment newMobileAppAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMobileAppAssignment);
    }

    @Override
    public IMobileAppAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (MobileAppAssignmentCollectionRequest)this;
    }

    @Override
    public IMobileAppAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (MobileAppAssignmentCollectionRequest)this;
    }

    @Override
    public IMobileAppAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (MobileAppAssignmentCollectionRequest)this;
    }

    public IMobileAppAssignmentCollectionPage buildFromResponse(BaseMobileAppAssignmentCollectionResponse response) {
        MobileAppAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppAssignmentCollectionPage page = new MobileAppAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

