/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationState;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationStateCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationStateCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceConfigurationStateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceConfigurationStateRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationStateCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationStateCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceConfigurationStateCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceConfigurationStateCollectionRequest;
import java.util.List;

public class BaseDeviceConfigurationStateCollectionRequest
extends BaseCollectionRequest<BaseDeviceConfigurationStateCollectionResponse, IDeviceConfigurationStateCollectionPage>
implements IBaseDeviceConfigurationStateCollectionRequest {
    public BaseDeviceConfigurationStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceConfigurationStateCollectionResponse.class, IDeviceConfigurationStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceConfigurationStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceConfigurationStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationStateCollectionPage get() throws ClientException {
        BaseDeviceConfigurationStateCollectionResponse response = (BaseDeviceConfigurationStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationState newDeviceConfigurationState, ICallback<DeviceConfigurationState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationState, callback);
    }

    @Override
    public DeviceConfigurationState post(DeviceConfigurationState newDeviceConfigurationState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationState);
    }

    @Override
    public IDeviceConfigurationStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceConfigurationStateCollectionRequest)this;
    }

    @Override
    public IDeviceConfigurationStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceConfigurationStateCollectionRequest)this;
    }

    @Override
    public IDeviceConfigurationStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceConfigurationStateCollectionRequest)this;
    }

    public IDeviceConfigurationStateCollectionPage buildFromResponse(BaseDeviceConfigurationStateCollectionResponse response) {
        DeviceConfigurationStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationStateCollectionPage page = new DeviceConfigurationStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

