/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceScheduledActionForRule;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceScheduledActionForRuleCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceScheduledActionForRuleCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceComplianceScheduledActionForRuleCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceComplianceScheduledActionForRuleCollectionRequest;
import java.util.List;

public class BaseDeviceComplianceScheduledActionForRuleCollectionRequest
extends BaseCollectionRequest<BaseDeviceComplianceScheduledActionForRuleCollectionResponse, IDeviceComplianceScheduledActionForRuleCollectionPage>
implements IBaseDeviceComplianceScheduledActionForRuleCollectionRequest {
    public BaseDeviceComplianceScheduledActionForRuleCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceComplianceScheduledActionForRuleCollectionResponse.class, IDeviceComplianceScheduledActionForRuleCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceScheduledActionForRuleCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceComplianceScheduledActionForRuleCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionPage get() throws ClientException {
        BaseDeviceComplianceScheduledActionForRuleCollectionResponse response = (BaseDeviceComplianceScheduledActionForRuleCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceScheduledActionForRule newDeviceComplianceScheduledActionForRule, ICallback<DeviceComplianceScheduledActionForRule> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceScheduledActionForRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceScheduledActionForRule, callback);
    }

    @Override
    public DeviceComplianceScheduledActionForRule post(DeviceComplianceScheduledActionForRule newDeviceComplianceScheduledActionForRule) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceScheduledActionForRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceComplianceScheduledActionForRule);
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceComplianceScheduledActionForRuleCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceComplianceScheduledActionForRuleCollectionRequest)this;
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceComplianceScheduledActionForRuleCollectionRequest)this;
    }

    public IDeviceComplianceScheduledActionForRuleCollectionPage buildFromResponse(BaseDeviceComplianceScheduledActionForRuleCollectionResponse response) {
        DeviceComplianceScheduledActionForRuleCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceScheduledActionForRuleCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceScheduledActionForRuleCollectionPage page = new DeviceComplianceScheduledActionForRuleCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

