/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceCompliancePolicyCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceCompliancePolicyCollectionRequest;
import java.util.List;

public class BaseDeviceCompliancePolicyCollectionRequest
extends BaseCollectionRequest<BaseDeviceCompliancePolicyCollectionResponse, IDeviceCompliancePolicyCollectionPage>
implements IBaseDeviceCompliancePolicyCollectionRequest {
    public BaseDeviceCompliancePolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceCompliancePolicyCollectionResponse.class, IDeviceCompliancePolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCompliancePolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceCompliancePolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCompliancePolicyCollectionPage get() throws ClientException {
        BaseDeviceCompliancePolicyCollectionResponse response = (BaseDeviceCompliancePolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceCompliancePolicy newDeviceCompliancePolicy, ICallback<DeviceCompliancePolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceCompliancePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCompliancePolicy, callback);
    }

    @Override
    public DeviceCompliancePolicy post(DeviceCompliancePolicy newDeviceCompliancePolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceCompliancePolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCompliancePolicy);
    }

    @Override
    public IDeviceCompliancePolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceCompliancePolicyCollectionRequest)this;
    }

    @Override
    public IDeviceCompliancePolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceCompliancePolicyCollectionRequest)this;
    }

    @Override
    public IDeviceCompliancePolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceCompliancePolicyCollectionRequest)this;
    }

    public IDeviceCompliancePolicyCollectionPage buildFromResponse(BaseDeviceCompliancePolicyCollectionResponse response) {
        DeviceCompliancePolicyCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCompliancePolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCompliancePolicyCollectionPage page = new DeviceCompliancePolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

